# error "test" 
	// *******************************************************************************************
	// PASS 3: 
	// 
	// Task:
	// establish sharing of prefixes within one descriptor. The following subtasks are performed:
	// 1)	compute base offsets for each descriptor (within the descriptor address table)
	// 2)	modify the encoded graph to virtual offsets (within the descriptor address table)
	// *******************************************************************************************
// pass3
share_prefixes:
	cmpl	$0,free							// free >= 0
	jle		GC_FIXED_STACK
	
# define temp %eax
	movl	stackTop,temp
	subl	descStackTop,temp				// temp
	shrl	$1,temp
	
	subl	temp,free						// reserve for descriptor address table
	js		GC_FIXED_STACK
# undef temp
	
	movl	heapP,descriptor_address_table_base		// init
	
	movl	$4,virtual_base_offset				// initial virtual base offset

	movl	root_node,nodeP					// root of graph
	
	movl	old_heap_pointer,stringP

	leal	((2 * 4) + HEADER_SIZE)(stringP),stringP
	
	jmp		share_prefixes_in_nodeP

share_next_prefix:
	_stack_empty share_prefixes_done
	_popl	nodeP

share_prefixes_in_nodeP:
# define t1	arity	// %ecx
	movl	(stringP),t1					// t1 = encoded node
	testl	$1,t1
	jne		share_prefixes_indirection		// an indirection; share_next_prefix; advance stringP

# define ML(x)				x##_sp
# define GTS_COPY_ONLY_ENCODE_MACRO
# include "gts_copy.c"
	ML(_adapt_encoded_graph) t1 //l2137
# undef t1
	
	movl	(nodeP),descP
	
# define SHARE_PREFIXES

# define ENTRY_LABEL			share_next_prefix
# define ENTRY_LABEL_NODEP	share_prefixes_in_nodeP
# define EXIT_LABEL			share_prefixes_done
# include "gts_copy.c"
# undef EXIT_LABEL

#  ifdef SHARE_PREFIXES
share_prefixes_indirection:
	leal	4(stringP),stringP
	jmp		share_next_prefix
#  endif

share_prefixes_done:
